/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.animation.SubGuiEditAnimation;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;

public class GuiNpcAnimation
extends GuiNPCInterface2
implements ISubGuiListener,
ICustomScrollListener,
IGuiData,
GuiYesNoCallback {
    public static int backColor = -16777216;
    private GuiCustomScroll scrollType;
    private GuiCustomScroll scrollAnimations;
    private GuiCustomScroll scrollAllAnimations;
    private boolean isChanged = true;
    private final LinkedHashMap<Integer, List<String>> typeHovers = new LinkedHashMap();
    private final Map<String, AnimationKind> dataType = new LinkedHashMap<String, AnimationKind>();
    private final List<String> dataAnimations = new ArrayList<String>();
    private final Map<String, AnimationConfig> dataAllAnimations = new TreeMap<String, AnimationConfig>();
    private final EntityNPCInterface npcAnim;
    private final DataAnimation animation;
    private String selType = "";
    private String selAnim = "";
    private String selBaseAnim = "";
    private AnimationController aData;

    public GuiNpcAnimation(EntityCustomNpc npc) {
        super(npc, 4);
        this.closeOnEsc = true;
        this.animation = new DataAnimation((EntityLivingBase)npc);
        this.setBackground("bgfilled.png");
        this.dataType.clear();
        this.dataType.put("puppet." + AnimationKind.INIT.name().toLowerCase().replace("_", ""), AnimationKind.INIT);
        this.dataType.put("puppet." + AnimationKind.JUMP.name().toLowerCase().replace("_", ""), AnimationKind.JUMP);
        this.dataType.put("puppet." + AnimationKind.ATTACKING.name().toLowerCase().replace("_", ""), AnimationKind.ATTACKING);
        this.dataType.put("puppet." + AnimationKind.SHOOT.name().toLowerCase().replace("_", ""), AnimationKind.SHOOT);
        this.dataType.put("puppet." + AnimationKind.AIM.name().toLowerCase().replace("_", ""), AnimationKind.AIM);
        this.dataType.put("puppet." + AnimationKind.SWING.name().toLowerCase().replace("_", ""), AnimationKind.SWING);
        this.dataType.put("puppet." + AnimationKind.HIT.name().toLowerCase().replace("_", ""), AnimationKind.HIT);
        this.dataType.put("puppet." + AnimationKind.DIES.name().toLowerCase().replace("_", ""), AnimationKind.DIES);
        this.dataType.put("puppet." + AnimationKind.BASE.name().toLowerCase().replace("_", ""), AnimationKind.BASE);
        this.dataType.put("puppet." + AnimationKind.INTERACT.name().toLowerCase().replace("_", ""), AnimationKind.INTERACT);
        this.dataType.put("puppet." + AnimationKind.BLOCKED.name().toLowerCase().replace("_", ""), AnimationKind.BLOCKED);
        this.dataType.put("puppet." + AnimationKind.STANDING.name().toLowerCase().replace("_", ""), AnimationKind.STANDING);
        this.dataType.put("puppet." + AnimationKind.FLY_STAND.name().toLowerCase().replace("_", ""), AnimationKind.FLY_STAND);
        this.dataType.put("puppet." + AnimationKind.WATER_STAND.name().toLowerCase().replace("_", ""), AnimationKind.WATER_STAND);
        this.dataType.put("puppet." + AnimationKind.REVENGE_STAND.name().toLowerCase().replace("_", ""), AnimationKind.REVENGE_STAND);
        this.dataType.put("puppet." + AnimationKind.WALKING.name().toLowerCase().replace("_", ""), AnimationKind.WALKING);
        this.dataType.put("puppet." + AnimationKind.FLY_WALK.name().toLowerCase().replace("_", ""), AnimationKind.FLY_WALK);
        this.dataType.put("puppet." + AnimationKind.WATER_WALK.name().toLowerCase().replace("_", ""), AnimationKind.WATER_WALK);
        this.dataType.put("puppet." + AnimationKind.REVENGE_WALK.name().toLowerCase().replace("_", ""), AnimationKind.REVENGE_WALK);
        int i = 0;
        for (AnimationKind ak : this.dataType.values()) {
            String hoverText = new TextComponentTranslation("animation.hover.anim." + ak.get(), new Object[0]).func_150254_d();
            this.typeHovers.put(i, Arrays.asList(hoverText.split("<br>")));
            ++i;
        }
        this.npcAnim = Util.instance.copyToGUI(npc, (World)this.field_146297_k.field_71441_e, false);
        this.npcAnim.display.setName(npc.func_70005_c_() + "_animation");
        Client.sendData(EnumPacketServer.AnimationGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        AnimationConfig anim = this.getAnim();
        switch (button.getID()) {
            case 0: {
                if (this.scrollType == null || !this.scrollType.hasSelected()) {
                    return;
                }
                AnimationConfig newAnim = (AnimationConfig)this.aData.createNewAnim();
                newAnim.name = Util.instance.deleteColor(new TextComponentTranslation(this.selType, new Object[0]).func_150254_d().replaceAll(" ", "_") + "_" + newAnim.id);
                newAnim.type = this.dataType.get(this.selType);
                this.animation.addAnimation(newAnim.type, newAnim.id);
                this.selAnim = newAnim.getSettingName();
                this.isChanged = true;
                this.func_73866_w_();
                CustomNPCsScheduler.runTack(() -> this.setSubGui(new SubGuiEditAnimation(this.npc, newAnim, 4, this)), 50);
                break;
            }
            case 1: {
                if (anim == null) {
                    return;
                }
                AnimationController aData = AnimationController.getInstance();
                anim = anim.copy();
                anim.id = aData.getUnusedAnimId();
                anim.immutable = false;
                anim.type = this.dataType.get(this.selType);
                aData.animations.put(anim.id, anim);
                this.selAnim = anim.getSettingName();
                this.selBaseAnim = anim.getSettingName();
                if (this.dataType.containsKey(this.selType)) {
                    this.animation.addAnimation(this.dataType.get(this.selType), anim.id);
                }
                this.isChanged = true;
                this.func_73866_w_();
                break;
            }
            case 2: {
                if (anim == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, anim.getSettingName(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 3: {
                if (anim == null || !this.dataType.containsKey(this.selType)) {
                    return;
                }
                this.setSubGui(new SubGuiEditAnimation(this.npc, anim, 4, this));
                break;
            }
            case 4: {
                backColor = backColor == -16777216 ? -1 : -16777216;
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        AnimationConfig anim = this.getAnim();
        if (id == 0) {
            if (anim == null) {
                return;
            }
            if (this.dataType.containsKey(this.selType)) {
                this.animation.removeAnimation(this.dataType.get(this.selType), anim.id);
            }
            AnimationController.getInstance().removeAnimation(anim.id);
            this.isChanged = true;
            this.func_73866_w_();
        }
    }

    @Override
    public void close() {
        this.save();
        CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuAdvanced);
    }

    @Override
    public void save() {
        Client.sendData(EnumPacketServer.AnimationSave, this.animation.save(new NBTTagCompound()));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.subgui != null) {
            this.subgui.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        AnimationConfig anim = this.getAnim();
        if (anim != null && !this.hasSubGui() && this.npcAnim != null) {
            this.npcAnim.animation.updateTime();
            this.npcAnim.field_20061_w = this.npc.field_20061_w;
            this.npcAnim.field_20062_v = this.npc.field_20062_v;
            this.npcAnim.field_20063_u = this.npc.field_20063_u;
            this.npcAnim.field_20064_t = this.npc.field_20064_t;
            this.npcAnim.field_20065_s = this.npc.field_20065_s;
            this.npcAnim.field_20066_r = this.npc.field_20066_r;
            this.npcAnim.field_70173_aa = this.npc.field_70173_aa;
            this.npcAnim.field_70725_aQ = 0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.guiLeft + 342.0f), (float)((float)this.guiTop + 9.0f), (float)0.0f);
            Gui.func_73734_a((int)-1, (int)-1, (int)56, (int)91, (int)-1015568);
            Gui.func_73734_a((int)0, (int)0, (int)55, (int)90, (int)backColor);
            GlStateManager.func_179121_F();
            this.drawNpc((Entity)this.npcAnim, 369, 81, 1.0f, 0, 0, 0);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)this.guiLeft + 315.0f), (float)((float)this.guiTop - 2.0f), (float)0.0f);
        int color = -1610612736;
        int hoverButton = -1;
        for (int i = 0; i < 5; ++i) {
            GlStateManager.func_179109_b((float)0.0f, (float)22.0f, (float)0.0f);
            int c = color;
            if (this.getButton(i) != null && this.getButton(i).isHovered()) {
                c = -1593835776;
                hoverButton = i;
            }
            this.func_73730_a(0, 0, 0, color);
            this.func_73730_a(0, 1, 1, color);
            this.func_73730_a(0, 2, 2, color);
            this.func_73730_a(0, 3, 3, color);
            this.func_73730_a(0, 0, 4, color);
            this.func_73730_a(1, 14, 4, c);
            this.func_73730_a(0, 3, 5, color);
            this.func_73730_a(0, 2, 6, color);
            this.func_73730_a(0, 1, 7, color);
            this.func_73730_a(0, 0, 8, color);
        }
        GlStateManager.func_179109_b((float)11.0f, (float)-10.0f, (float)0.0f);
        this.func_73728_b(0, 0, 2, color);
        this.func_73728_b(1, -1, 2, color);
        this.func_73728_b(2, -2, 2, color);
        this.func_73728_b(3, -3, 2, color);
        this.func_73728_b(4, 0, 2, color);
        if (hoverButton != -1) {
            this.func_73728_b(4, -75 + hoverButton * 22, 1, -1593835776);
            if (hoverButton != 0) {
                this.func_73728_b(4, -75, -74 + hoverButton * 22, color);
            }
        } else {
            this.func_73728_b(4, -75, 1, color);
        }
        this.func_73728_b(5, -3, 2, color);
        this.func_73728_b(6, -2, 2, color);
        this.func_73728_b(7, -1, 2, color);
        this.func_73728_b(8, 0, 2, color);
        GlStateManager.func_179121_F();
    }

    private AnimationConfig getAnim() {
        if (!this.dataAnimations.contains(this.selAnim) && !this.selAnim.isEmpty()) {
            this.selAnim = "";
        }
        if (!this.selAnim.isEmpty() && this.dataAllAnimations.containsKey(this.selAnim)) {
            return this.dataAllAnimations.get(this.selAnim);
        }
        if (this.selBaseAnim.isEmpty() || !this.dataAllAnimations.containsKey(this.selBaseAnim)) {
            return null;
        }
        return this.dataAllAnimations.get(this.selBaseAnim);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.guiLeft + 8;
        int y = this.guiTop + 14;
        if (this.scrollType == null) {
            this.scrollType = new GuiCustomScroll(this, 0);
            this.scrollType.setSize(120, 198);
            this.scrollType.setListNotSorted(new ArrayList<String>(this.dataType.keySet()));
            this.scrollType.setHoverTexts(this.typeHovers);
        }
        this.scrollType.guiLeft = x;
        this.scrollType.guiTop = y;
        this.addScroll(this.scrollType);
        if (this.selType.isEmpty()) {
            for (String key : this.dataType.keySet()) {
                if (this.dataType.get(key) != AnimationKind.STANDING) continue;
                this.selType = key;
                break;
            }
        }
        this.scrollType.setSelected(this.selType);
        this.addLabel(new GuiNpcLabel(0, "animation.type", x + 1, y - 10));
        x += 123;
        this.dataAnimations.clear();
        this.dataAllAnimations.clear();
        this.aData = AnimationController.getInstance();
        ArrayList allAnimations = Lists.newArrayList();
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        AnimationKind type = this.dataType.get(this.selType);
        if (!(this.selAnim.isEmpty() || this.selBaseAnim.isEmpty() || Util.instance.deleteColor(this.selAnim).equals(Util.instance.deleteColor(this.selBaseAnim)))) {
            this.selAnim = "";
        }
        Iterator<Object> iterator = this.aData.animations.values().iterator();
        while (iterator.hasNext()) {
            AnimationConfig ac = iterator.next();
            String key = '\u00a7' + (type == ac.type ? "a" : "7") + ac.getSettingName();
            if (this.animation.hasAnimation(type, ac.id)) {
                this.dataAnimations.add(key);
            }
            this.dataAllAnimations.put(key, ac);
            if (!this.selAnim.isEmpty() && Util.instance.deleteColor(this.selAnim).equals(Util.instance.deleteColor(key))) {
                this.selAnim = key;
            }
            if (!this.selBaseAnim.isEmpty() && Util.instance.deleteColor(this.selBaseAnim).equals(Util.instance.deleteColor(key))) {
                this.selBaseAnim = key;
            }
            allAnimations.add(key);
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TextComponentTranslation(ac.name, new Object[0]).func_150254_d());
            list.add("\u00a77" + new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "r" + ac.type.name());
            hts.put(i, list);
            ++i;
        }
        if (this.scrollAnimations == null) {
            this.scrollAnimations = new GuiCustomScroll(this, 1);
            this.scrollAnimations.setSize(120, 198);
            this.scrollAnimations.setHoverText("animation.hover.anim.list", new Object[0]);
        }
        this.scrollAnimations.setListNotSorted(this.dataAnimations);
        this.scrollAnimations.guiLeft = x;
        this.scrollAnimations.guiTop = y;
        this.addScroll(this.scrollAnimations);
        if (this.selAnim.isEmpty() && this.selBaseAnim.isEmpty() && !this.scrollAnimations.getList().isEmpty() && (iterator = this.scrollAnimations.getList().iterator()).hasNext()) {
            String key;
            this.selAnim = key = (String)iterator.next();
            this.selBaseAnim = key;
        }
        if (!this.selAnim.isEmpty()) {
            this.scrollAnimations.setSelected(this.selAnim);
            this.selAnim = !this.scrollAnimations.hasSelected() ? "" : this.scrollAnimations.getSelected();
        } else {
            this.scrollAnimations.setSelected(null);
        }
        if (this.selBaseAnim.isEmpty()) {
            this.selBaseAnim = this.selAnim;
        }
        x += 123;
        if (this.scrollAllAnimations == null) {
            this.scrollAllAnimations = new GuiCustomScroll(this, 2);
            this.scrollAllAnimations.setSize(160, 110);
        }
        this.scrollAllAnimations.setListNotSorted(allAnimations);
        this.scrollAllAnimations.setHoverTexts(hts);
        this.scrollAllAnimations.guiLeft = x;
        this.scrollAllAnimations.guiTop = y + 88;
        if (!this.selBaseAnim.isEmpty()) {
            this.scrollAllAnimations.setSelected(this.selBaseAnim);
        }
        this.addScroll(this.scrollAllAnimations);
        AnimationConfig anim = this.getAnim();
        this.addLabel(new GuiNpcLabel(1, new TextComponentTranslation("movement.animation", new Object[0]).func_150254_d() + ":", x + 1, y - 10));
        GuiNpcButton button = new GuiNpcButton(0, x, y, 60, 20, "markov.generate");
        button.setHoverText("animation.hover.anim.create", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(4, x + 148, y, 10, 10, new String[]{"b", "w"}, backColor == -16777216 ? 0 : 1);
        button.setHoverText("animation.hover.color", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x, y += 22, 60, 20, "gui.copy");
        button.setEnabled(anim != null);
        button.setHoverText("animation.hover.anim.copy", new Object[0]);
        this.addButton(button);
        boolean isOP = anim != null && !anim.immutable;
        button = new GuiNpcButton(2, x, y += 22, 60, 20, "gui.remove");
        button.setEnabled(isOP);
        button.setHoverText("animation.hover.anim.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, x, y + 22, 60, 20, "gui.edit");
        button.setEnabled(isOP);
        button.setHoverText("animation.hover.anim.edit", new Object[0]);
        this.addButton(button);
        this.resetAnimation();
    }

    private void resetAnimation() {
        if (!this.isChanged) {
            return;
        }
        AnimationConfig anim = this.getAnim();
        if (anim == null || this.npcAnim == null) {
            return;
        }
        anim = anim.copy();
        anim.type = this.dataType.get(this.selType);
        this.npcAnim.animation.reset();
        this.npcAnim.animation.tryRunAnimation(anim, AnimationKind.EDITING_All);
        this.npcAnim.func_70606_j(this.npcAnim.func_110138_aP());
        this.npcAnim.field_70725_aQ = 0;
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            if (this.selType.equals(scroll.getSelected())) {
                return;
            }
            this.selType = scroll.getSelected();
            this.isChanged = true;
        } else if (scroll.getID() == 1) {
            if (this.selAnim.equals(scroll.getSelected())) {
                return;
            }
            this.selAnim = scroll.getSelected();
            this.scrollAllAnimations.setSelected(this.selAnim);
            this.selBaseAnim = this.scrollAllAnimations.getSelected();
            this.isChanged = true;
        } else if (scroll.getID() == 2) {
            if (this.selBaseAnim.equals(scroll.getSelected())) {
                return;
            }
            this.selBaseAnim = scroll.getSelected();
            if (this.scrollAnimations.hasSelected(this.selBaseAnim)) {
                this.scrollAnimations.setSelected(this.selBaseAnim);
                this.selAnim = this.scrollAnimations.getSelected();
            }
            this.isChanged = true;
        }
        if (this.isChanged) {
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (scroll.getID() == 1) {
            AnimationConfig anim = this.getAnim();
            if (anim == null) {
                return;
            }
            AnimationKind type = this.dataType.get(this.selType);
            if (this.animation.hasAnimation(type, anim.id) && this.animation.removeAnimation(type, anim.id)) {
                this.isChanged = true;
                this.func_73866_w_();
            }
        } else if (scroll.getID() == 2) {
            if (this.scrollAnimations.hasSelected(this.selBaseAnim)) {
                return;
            }
            AnimationConfig anim = this.dataAllAnimations.get(this.selBaseAnim);
            if (anim == null) {
                return;
            }
            this.selAnim = anim.getSettingName();
            this.selBaseAnim = anim.getSettingName();
            AnimationKind type = this.dataType.get(this.selType);
            if (!this.animation.hasAnimation(type, anim.id)) {
                this.animation.addAnimation(type, anim.id);
            }
            this.isChanged = true;
            this.func_73866_w_();
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.animation.load(compound);
        this.isChanged = true;
        this.func_73866_w_();
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui.getId() == 4) {
            this.displayGuiScreen(this);
            if (!(subgui instanceof SubGuiEditAnimation) || ((SubGuiEditAnimation)subgui).anim == null) {
                return;
            }
            this.selBaseAnim = this.selAnim = ((SubGuiEditAnimation)subgui).anim.getSettingName();
            Client.sendData(EnumPacketServer.AnimationChange, ((SubGuiEditAnimation)subgui).anim.save());
            this.isChanged = true;
            this.func_73866_w_();
        }
    }
}

